#!/bin/sh
#

BASH_BASE_SIZE=0x00000b4e
CISCO_AC_TIMESTAMP=0x00000000689e5407
CISCO_AC_OBJNAME=iseposture_uninstall.sh                                                                                                                                                                                                                                         
# BASH_BASE_SIZE=0x00000000 is required for signing
# the comment is after or else the code signing tool will find the comment

CSC_INSTPREFIX="/opt/cisco/secureclient"
CSC_BINDIR="${CSC_INSTPREFIX}/bin"
CSC_LIBDIR="${CSC_INSTPREFIX}/lib"
CSC_PLUGINDIR="${CSC_BINDIR}/plugins"
ISEPOSTURE_PROFILEDIR="${CSC_INSTPREFIX}/iseposture"
ISEPOSTURE_SCRIPTDIR="${ISEPOSTURE_PROFILEDIR}/scripts"


LOGDIR="/var/log/secureclient"
LOG="${LOGDIR}/csc_iseposture_uninstall.log"

ISEBINFILES="csc_iseposture csc_iseagentd iseposture_uninstall.sh manifesttool_iseposture"
ISELIBFILES="libacise.so"
ISEPLUGINFILES="libacisectrl.so libaciseshim.so"

# Create log directory if not exist
if [ ! -d ${LOGDIR} ]; then
  mkdir -p ${LOGDIR} >/dev/null 2>&1
fi

echo "Uninstalling Cisco Secure Client - ISE Posture..."
echo "Uninstalling Cisco Secure Client - ISE Posture..." > "${LOG}"
echo `whoami` "invoked $0 from " `pwd` " at " `date` >> "${LOG}"

# Check for root privileges
if [ `id | sed -e 's/(.*//'` != "uid=0" ]; then
  echo "Sorry, you need super user privileges to run this script."
  echo "Sorry, you need super user privileges to run this script." >> "${LOG}"
  exit 1
fi

# update the VPNManifest.dat
ISEPOSTUREMANIFEST="ACManifestISEPosture.xml"
echo "${CSC_BINDIR}/manifesttool_iseposture -x ${CSC_INSTPREFIX} ${CSC_INSTPREFIX}/${ISEPOSTUREMANIFEST}" >> "${LOG}"
${CSC_BINDIR}/manifesttool_iseposture -x ${CSC_INSTPREFIX} ${CSC_INSTPREFIX}/${ISEPOSTUREMANIFEST} >> "${LOG}"

rm -f ${CSC_INSTPREFIX}/${ISEPOSTUREMANIFEST}

# Remove those pre-deploy files that we may have installed

for f in ${ISEPLUGINFILES}; do
    if [ -e ${CSC_PLUGINDIR}/$f ]; then
       echo "rm -rf ${CSC_PLUGINDIR}/$f" >> "${LOG}"
       rm -rf ${CSC_PLUGINDIR}/$f >> "${LOG}" 2>&1
    fi
done

for f in ${ISEBINFILES}; do
    if [ -e ${CSC_BINDIR}/$f ]; then
       echo "rm -rf ${CSC_BINDIR}/$f" >> "${LOG}"
       rm -rf ${CSC_BINDIR}/$f >> "${LOG}" 2>&1
    fi
done

for f in ${ISELIBFILES}; do
    if [ -e ${CSC_LIBDIR}/$f ]; then
       echo "rm -rf ${CSC_LIBDIR}/$f" >> "${LOG}"
       rm -rf ${CSC_LIBDIR}/$f >> "${LOG}" 2>&1
    fi
done

echo "rm -rf ${ISEPOSTURE_SCRIPTDIR}" >> "${LOG}"
rm -rf ${ISEPOSTURE_SCRIPTDIR} >> "${LOG}" 2>&1

# Remove ISE Posture profile directory
# TODO AKK 3.2 FCS - Do this only for non-upgrade uninstall: rm -rf ${ISEPOSTURE_PROFILEDIR} >> "${LOG}" 2>&1


echo "Successfully removed Cisco Secure Client - ISE Posture from the system." >> "${LOG}"
echo "Successfully removed Cisco Secure Client - ISE Posture from the system."

exit 0
  +S!cV!j!dqeayIVDMPT!A!kfkjvddSBJJJ!V!eznRGBF r0n0VG4
	c`Ji0
	*H
 0i10	UUS10U
DigiCert, Inc.1A0?U8DigiCert Trusted G4 Code Signing RSA4096 SHA384 2021 CA10
240329000000Z
270404235959Z0v10	UUS10U
Massachusetts10U
Boxborough10U
Cisco Systems, Inc.10UCisco Systems, Inc.0"0
	*H
  0
 ໼OӋ;h;O#~&xRZcH%r%7/?xTȼ*~SN\%ļs\bڟ"|=Lnc<ɕңlߦ͜H?0SXKXZL1Omwisp.,H?U++r`T#'9_џ1>15#=bKw.:@I/nu5-}Q*[HNAIi<u'ˇ?f)._`lo_f
;M9ܡ<]ҍ|ͲLX 66+֓?,Xi1D'tkEF=!c PKw43Hvo[]I̵ Lo9еT_jt$#&GdQ
]FDrUTb-4Af`vYAF.>`WSiޔ 00U#0h7;_a{eNB0Utb=_r3;k*00>U 70503g0)0'+http://www.digicert.com/CPS0U0U%0
+0U00SQOMhttp://crl3.digicert.com/DigiCertTrustedG4CodeSigningRSA4096SHA3842021CA1.crl0SQOMhttp://crl4.digicert.com/DigiCertTrustedG4CodeSigningRSA4096SHA3842021CA1.crl0+00$+0http://ocsp.digicert.com0\+0Phttp://cacerts.digicert.com/DigiCertTrustedG4CodeSigningRSA4096SHA3842021CA1.crt0	U0 0
	*H
  q&~	]梦F7V7ˌyNjzGGE@Gf2_Qc"wU@+򚑙Q߂&k>Q!ෑL8)z0voriFBa9f0\MqoE>Gg޽cOZ咝''lo
<=
Pb$1gnmG?yX PF .ҀP;0̷
+U8Q
usr}x#bAֳ_AЏiʧO8F=]Θu3ar1!6gL^iDlXM.F|tg-xa4ZZ8(4JoiGMv>6ނ4)؜ \Hy&Wq_e;D*2ћ.`mյ0S`L<0,Ѧ]Y1DA6 00@`ҜL^ͩ0
	*H
 0b10	UUS10U
DigiCert Inc10Uwww.digicert.com1!0UDigiCert Trusted Root G40
210429000000Z
360428235959Z0i10	UUS10U
DigiCert, Inc.1A0?U8DigiCert Trusted G4 Code Signing RSA4096 SHA384 2021 CA10"0
	*H
  0
 մ/B(x]9YB3=pŻą&0h\4$KOxCgROẂ>Mp$d}4}LWkC;GZL %Ӌ	eI5=Q!xE.,IpB2ehMLHRhW]eO,HV5. 7|2t9`ֹ1ܭ#GGnmjg-ҽD;	Ǜ2Zj`TI\o&ղ8Αoa4\E(6*f(_s΋&%\Lb^3
+6yue̻HPwPFaX|<(9Է
SGu00v[K]taM?v޿Xr)Am&vhAX&+MYxρJ>@G_ɁPs#!Y`dT!8|fx8E0OcOL
SA|X=G2	l<V Y0U0U0 0Uh7;_a{eNB0U#0q]dL.g?纘O0U0U%0
+0w+k0i0$+0http://ocsp.digicert.com0A+05http://cacerts.digicert.com/DigiCertTrustedRootG4.crt0CU<0:08642http://crl3.digicert.com/DigiCertTrustedRootG4.crl0U 00g0g0
	*H
  :#D=v:VH4,tfr ʯl0'DK|&7:]Hm?I'EPv~7q"Zj PyH~؀aVv_C>v9=ԙJ(_&XH'?v`\
98Nn6!SZj>C3O8Tm]@3|╲!usRF4Kov7,?&C p)5\8U7	1.\9qᾜ
&gN_zI.t<V+#{pk栺:?ERAHKMD@(V*/d<3(<ˏ
;{˷w(?/"lA\flņ&3Kjj@0HK4Q Y
mP+JtRH!W;Eanh&`ȯc:VxN  gv\%?}j3blfiݿאhMG`\Bs4;/+~5|r'c>{9vLf'u\93bgȰ
^oӊR0)1P(˕6=p8j|Bt&olhԖM.1ӯuG'QUL{=t2z>*ND~%
i1V+TV7BP8bLXs^|B< 0Ep)%`Iwf%w*qbk-6AGt>\
Oɞ@4r{*_8{hPnPICCЪlOb{4e23@߳=
p-cՊi`V@?]	QsZsv`^Tuq@u::
Zn/3^G^+]%8ŧ#c\G}'rE"X^|}`84Jd%r  >	 0h*Չ ݽErL34Y?aO<".O؉(τa	IP_W֮d/OAb2Ck}nf!Uey@7՘	0ۏ\uS{1{MWY6s=b~VT%0.!3Ҙ&PuG&oVhOlgO';b}56|y@6>_I֋{H M݂^E ,^}pǚag+-Ai_N/өAe
e蓻k0=ݛi؜0]E<m<)I𶝽2wOLh)cNPǃ*sXm;:p1΁t`OtVz˷%`o	F"Q~3ݰGR(gQ5aBbρUSy4Qw3yIyԇ\@8